package eu.europa.ec.taxud.cesop.validation;

import javax.xml.stream.XMLStreamException;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;

import eu.europa.ec.taxud.cesop.domain.MessageTypeEnum;
import eu.europa.ec.taxud.cesop.domain.ValidationError;
import eu.europa.ec.taxud.cesop.domain.ValidationResultTypeEnum;
import eu.europa.ec.taxud.cesop.domain.XmlPaymentDataMsg;
import eu.europa.ec.taxud.cesop.writers.ValidationMessageXmlWriter;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

/**
 * Result of Payment Data File validation.
 */
@Getter
@RequiredArgsConstructor
public class PspValidationResult {
    private final XmlPaymentDataMsg paymentDataMsg;
    private final List<ValidationError> errors;
    private final MessageTypeEnum messageType;

    public ValidationResultTypeEnum getResultType() {
        if (errors.isEmpty()) {
            return ValidationResultTypeEnum.VALIDATED;
        }
        if (errors.stream().anyMatch(ValidationError::isFullRejection)) {
            return ValidationResultTypeEnum.FULLY_REJECTED;
        }
        return ValidationResultTypeEnum.PARTIALLY_REJECTED;
    }

    public String getResultXml() throws XMLStreamException, IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (ValidationMessageXmlWriter validationMessageXmlWriter = new ValidationMessageXmlWriter(out)) {
            validationMessageXmlWriter.createValidationMessage(paymentDataMsg, errors);
        }
        return out.toString();
    }
}
